<?php
require_once '../../config/config.php';
require_once '../../config/auth.php';
require_once '../../config/database.php';
require_once '../../helpers/format_uang.php';

require_once '../../templates/header.php';
require_once '../../templates/sidebar.php';

// Ambil data stok
$stok = $db->query("SELECT * FROM inventory_stok ORDER BY nama_barang ASC");
?>

<h2>Data Stok Barang</h2>

<a href="masuk.php" class="btn">+ Barang Masuk</a>

<table class="table">
    <thead>
        <tr>
            <th>No</th>
            <th>Kode</th>
            <th>Nama Barang</th>
            <th>Harga</th>
            <th>Stok</th>
            <th>Satuan</th>
        </tr>
    </thead>
    <tbody>
        <?php $no=1; while($s = $stok->fetch_assoc()): ?>
        <tr>
            <td><?= $no++; ?></td>
            <td><?= $s['kode_barang']; ?></td>
            <td><?= $s['nama_barang']; ?></td>
            <td><?= format_uang($s['harga']); ?></td>
            <td><?= $s['stok']; ?></td>
            <td><?= $s['satuan']; ?></td>
        </tr>
        <?php endwhile; ?>
    </tbody>
</table>

<?php require_once '../../templates/footer.php'; ?>
